BEGIN TRANSACTION;
CREATE TABLE Companies(CompanyID INTEGER PRIMARY KEY AUTOINCREMENT, CompanyName TEXT);
INSERT INTO "Companies" VALUES(1,'TechCorp');
INSERT INTO "Companies" VALUES(2,'CodeInc');
INSERT INTO "Companies" VALUES(3,'DevMasters');
INSERT INTO "Companies" VALUES(4,'AppDevelopers');
INSERT INTO "Companies" VALUES(5,'GamingPioneers');
CREATE TABLE Jobs(JobID INTEGER PRIMARY KEY AUTOINCREMENT, JobTitle TEXT, Description TEXT, Salary REAL, CompanyID INTEGER, FOREIGN KEY(CompanyID) REFERENCES Companies(CompanyID));
INSERT INTO "Jobs" VALUES(1,'Software Engineer','Design and develop software applications.',80000.0,1);
INSERT INTO "Jobs" VALUES(2,'Mobile Application Developer','Create mobile apps using Java/Kotlin.',70000.0,2);
INSERT INTO "Jobs" VALUES(3,'Web Developer','Build and maintain websites.',60000.0,3);
INSERT INTO "Jobs" VALUES(4,'Data Scientist','Analyze complex datasets and provide insights.',90000.0,4);
INSERT INTO "Jobs" VALUES(5,'Game Designer','Design game concepts and create prototypes.',85000.0,5);
CREATE TABLE Languages(LanguageID INTEGER PRIMARY KEY AUTOINCREMENT, LanguageName TEXT);
INSERT INTO "Languages" VALUES(1,'Python');
INSERT INTO "Languages" VALUES(2,'JavaScript');
INSERT INTO "Languages" VALUES(3,'C#');
INSERT INTO "Languages" VALUES(4,'Ruby');
INSERT INTO "Languages" VALUES(5,'Swift');
CREATE TABLE Locations(LocationID INTEGER PRIMARY KEY AUTOINCREMENT, LocationName TEXT);
INSERT INTO "Locations" VALUES(1,'New York');
INSERT INTO "Locations" VALUES(2,'San Francisco');
INSERT INTO "Locations" VALUES(3,'London');
INSERT INTO "Locations" VALUES(4,'Tokyo');
INSERT INTO "Locations" VALUES(5,'Bangalore');
CREATE TABLE Skills(SkillID INTEGER PRIMARY KEY AUTOINCREMENT, SkillDescription TEXT);
INSERT INTO "Skills" VALUES(1,'Frontend Development');
INSERT INTO "Skills" VALUES(2,'Backend Development');
INSERT INTO "Skills" VALUES(3,'Full Stack Development');
INSERT INTO "Skills" VALUES(4,'Mobile App Development');
INSERT INTO "Skills" VALUES(5,'Machine Learning');
CREATE TABLE Software_Engineers(EngineerID INTEGER PRIMARY KEY AUTOINCREMENT, Name TEXT, Email TEXT, LocationID INTEGER, FOREIGN KEY(LocationID) REFERENCES Locations(LocationID));
INSERT INTO "Software_Engineers" VALUES(1,'John Doe','john@example.com',1);
INSERT INTO "Software_Engineers" VALUES(2,'Jane Smith','jane@example.com',1);
INSERT INTO "Software_Engineers" VALUES(3,'Alice Johnson','alice@example.com',2);
INSERT INTO "Software_Engineers" VALUES(4,'Bob Brown','bob@example.com',3);
INSERT INTO "Software_Engineers" VALUES(5,'Charlie Green','charlie@example.com',4);
CREATE TABLE Software_Engineers_Languages(SE_LanguageID INTEGER, SE_Id INTEGER, FOREIGN KEY(SE_LanguageID) REFERENCES Languages(LanguageID), FOREIGN KEY(SE_Id) REFERENCES Software_Engineers(EngineerID), PRIMARY KEY(SE_LanguageID, SE_Id));
INSERT INTO "Software_Engineers_Languages" VALUES(1,1);
INSERT INTO "Software_Engineers_Languages" VALUES(1,2);
INSERT INTO "Software_Engineers_Languages" VALUES(1,3);
INSERT INTO "Software_Engineers_Languages" VALUES(1,4);
INSERT INTO "Software_Engineers_Languages" VALUES(1,5);
INSERT INTO "Software_Engineers_Languages" VALUES(2,5);
DELETE FROM "sqlite_sequence";
INSERT INTO "sqlite_sequence" VALUES('Companies',5);
INSERT INTO "sqlite_sequence" VALUES('Locations',5);
INSERT INTO "sqlite_sequence" VALUES('Jobs',5);
INSERT INTO "sqlite_sequence" VALUES('Software_Engineers',5);
INSERT INTO "sqlite_sequence" VALUES('Languages',5);
INSERT INTO "sqlite_sequence" VALUES('Skills',5);
COMMIT;
